"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JobConfigErrorCallout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _kibana = require("../../../../../contexts/kibana");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const jobConfigErrorTitle = _i18n.i18n.translate('xpack.ml.dataframe.analytics.jobConfig.errorTitle', {
  defaultMessage: 'Unable to fetch results. An error occurred loading the job configuration data.'
});
const jobCapsErrorTitle = _i18n.i18n.translate('xpack.ml.dataframe.analytics.jobCaps.errorTitle', {
  defaultMessage: "Unable to fetch results. An error occurred loading the index's field data."
});
const JobConfigErrorCallout = ({
  jobCapsServiceErrorMessage,
  jobConfigErrorMessage,
  title
}) => {
  const {
    services: {
      application: {
        getUrlForApp
      }
    }
  } = (0, _kibana.useMlKibana)();
  const containsDataViewLink = typeof jobCapsServiceErrorMessage === 'string' && jobCapsServiceErrorMessage.includes('locate that index-pattern') && jobCapsServiceErrorMessage.includes('click here to re-create');
  const message = /*#__PURE__*/_react.default.createElement("p", null, jobConfigErrorMessage ? jobConfigErrorMessage : jobCapsServiceErrorMessage);
  const newDataViewUrl = (0, _react.useMemo)(() => getUrlForApp('management', {
    path: 'kibana/indexPatterns'
  }),
  // eslint-disable-next-line react-hooks/exhaustive-deps
  []);
  const calloutBody = containsDataViewLink ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: newDataViewUrl,
    target: "_blank"
  }, message) : message;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: jobConfigErrorMessage ? jobConfigErrorTitle : jobCapsErrorTitle,
    color: "danger",
    iconType: "cross"
  }, calloutBody));
};
exports.JobConfigErrorCallout = JobConfigErrorCallout;