"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DescriptionCell = DescriptionCell;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _metric_change_description = require("../../../../common/util/metric_change_description");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * Component for rendering the description cell in the anomalies table, which provides a
 * concise description of how the actual value of an anomaly compares to the typical value.
 */
function DescriptionCell({
  actual,
  typical
}) {
  const {
    iconType,
    message
  } = (0, _metric_change_description.getMetricChangeDescription)(actual, typical);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center"
  }, iconType !== undefined && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: iconType,
    size: "s"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, message)));
}
DescriptionCell.propTypes = {
  actual: _propTypes.default.oneOfType([_propTypes.default.array, _propTypes.default.number]),
  typical: _propTypes.default.oneOfType([_propTypes.default.array, _propTypes.default.number])
};