"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResultTypeSelector = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _mlAnomalyUtils = require("@kbn/ml-anomaly-utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ResultTypeSelector = exports.ResultTypeSelector = /*#__PURE__*/_react.default.memo(({
  value: selectedResultType = [],
  onChange,
  availableOption
}) => {
  const resultTypeOptions = (0, _react.useMemo)(() => {
    return [{
      value: _mlAnomalyUtils.ML_ANOMALY_RESULT_TYPE.BUCKET,
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.bucketResultType.title",
        defaultMessage: "Bucket"
      }),
      description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.bucketResultType.description",
        defaultMessage: "How unusual was the job within the bucket of time?"
      })
    }, {
      value: _mlAnomalyUtils.ML_ANOMALY_RESULT_TYPE.RECORD,
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.recordResultType.title",
        defaultMessage: "Record"
      }),
      description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.recordResultType.description",
        defaultMessage: "What individual anomalies are present in a time range?"
      })
    }, {
      value: _mlAnomalyUtils.ML_ANOMALY_RESULT_TYPE.INFLUENCER,
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.influencerResultType.title",
        defaultMessage: "Influencer"
      }),
      description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ml.influencerResultType.description",
        defaultMessage: "What are the most unusual entities in a time range?"
      })
    }].filter(v => availableOption.includes(v.value));
  }, [availableOption]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.resultTypeSelector.formControlLabel",
      defaultMessage: "Result type"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, resultTypeOptions.map(({
    value,
    title,
    description
  }) => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: value
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
      title: title,
      titleSize: 'xs',
      paddingSize: 's',
      description: /*#__PURE__*/_react.default.createElement("small", null, description),
      selectable: {
        onClick: () => {
          if (selectedResultType === value) {
            // don't allow de-select
            return;
          }
          onChange(value);
        },
        isSelected: value === selectedResultType
      },
      "data-test-subj": `mlAnomalyAlertResult_${value}${value === selectedResultType ? '_selected' : ''}`
    }));
  })));
});