"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.featureMlCapabilities = exports.featureCapabilities = exports.basicLicenseMlCapabilities = exports.apmUserMlCapabilities = exports.alertingFeatures = exports.adminMlCapabilities = void 0;
exports.getDefaultCapabilities = getDefaultCapabilities;
exports.getPluginPrivileges = getPluginPrivileges;
exports.userMlCapabilities = void 0;
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _common = require("@kbn/alerting-plugin/common");
var _app = require("../constants/app");
var _saved_objects = require("./saved_objects");
var _alerts = require("../constants/alerts");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const apmUserMlCapabilities = exports.apmUserMlCapabilities = {
  canGetJobs: false
};
const featureMlCapabilities = exports.featureMlCapabilities = {
  isADEnabled: true,
  isDFAEnabled: true,
  isNLPEnabled: true
};
const userMlCapabilities = exports.userMlCapabilities = {
  // Anomaly Detection
  canGetJobs: false,
  canGetDatafeeds: false,
  // Calendars
  canGetCalendars: false,
  // File Data Visualizer
  canFindFileStructure: false,
  // Data Frame Analytics
  canGetDataFrameAnalytics: false,
  // Annotations
  canGetAnnotations: false,
  canCreateAnnotation: false,
  canDeleteAnnotation: false,
  // Alerts
  canUseMlAlerts: false,
  // Trained models
  canGetTrainedModels: false,
  canTestTrainedModels: false,
  canGetFieldInfo: false,
  canGetMlInfo: false,
  // AIOps
  canUseAiops: false
};
const adminMlCapabilities = exports.adminMlCapabilities = {
  // Anomaly Detection
  canCreateJob: false,
  canDeleteJob: false,
  canOpenJob: false,
  canCloseJob: false,
  canResetJob: false,
  canUpdateJob: false,
  canForecastJob: false,
  canDeleteForecast: false,
  canCreateDatafeed: false,
  canDeleteDatafeed: false,
  canStartStopDatafeed: false,
  canUpdateDatafeed: false,
  canPreviewDatafeed: false,
  // Filters
  canGetFilters: false,
  // Calendars
  canCreateCalendar: false,
  canDeleteCalendar: false,
  // Filters
  canCreateFilter: false,
  canDeleteFilter: false,
  // Data Frame Analytics
  canCreateDataFrameAnalytics: false,
  canDeleteDataFrameAnalytics: false,
  canStartStopDataFrameAnalytics: false,
  // Alerts
  canCreateMlAlerts: false,
  canUseMlAlerts: false,
  // Model management
  canViewMlNodes: false,
  // Trained models
  canCreateTrainedModels: false,
  canDeleteTrainedModels: false,
  canStartStopTrainedModels: false,
  // Inference models
  canCreateInferenceEndpoint: false
};
const basicLicenseMlCapabilities = exports.basicLicenseMlCapabilities = ['canFindFileStructure', 'canGetFieldInfo', 'canGetMlInfo'];
function getDefaultCapabilities() {
  return {
    ...featureMlCapabilities,
    ...userMlCapabilities,
    ...adminMlCapabilities
  };
}
const alertingFeatures = exports.alertingFeatures = Object.values(_alerts.ML_ALERT_TYPES).map(ruleTypeId => ({
  ruleTypeId,
  consumers: [_app.PLUGIN_ID, _common.ALERTING_FEATURE_ID, ..._ruleDataUtils.DEPRECATED_ALERTING_CONSUMERS]
}));
function getPluginPrivileges() {
  const apmUserMlCapabilitiesKeys = Object.keys(apmUserMlCapabilities);
  const userMlCapabilitiesKeys = Object.keys(userMlCapabilities);
  const featureMlCapabilitiesKeys = Object.keys(featureMlCapabilities);
  const adminMlCapabilitiesKeys = Object.keys(adminMlCapabilities);
  const allMlCapabilitiesKeys = [...featureMlCapabilitiesKeys, ...adminMlCapabilitiesKeys, ...userMlCapabilitiesKeys];
  const savedObjects = ['index-pattern', 'dashboard', 'search', 'visualization', _saved_objects.ML_JOB_SAVED_OBJECT_TYPE, _saved_objects.ML_MODULE_SAVED_OBJECT_TYPE, _saved_objects.ML_TRAINED_MODEL_SAVED_OBJECT_TYPE];
  const privilege = {
    app: [_app.PLUGIN_ID, 'kibana'],
    excludeFromBasePrivileges: false,
    management: {
      insightsAndAlerting: ['jobsListLink', 'triggersActions']
    },
    catalogue: [_app.PLUGIN_ID]
  };
  return {
    admin: {
      ...privilege,
      api: ['fileUpload:analyzeFile', ...allMlCapabilitiesKeys.map(k => `ml:${k}`)],
      catalogue: [_app.PLUGIN_ID, `${_app.PLUGIN_ID}_file_data_visualizer`],
      ui: allMlCapabilitiesKeys,
      savedObject: {
        all: savedObjects,
        read: savedObjects
      },
      alerting: {
        rule: {
          all: alertingFeatures
        },
        alert: {
          all: alertingFeatures
        }
      }
    },
    user: {
      ...privilege,
      api: ['fileUpload:analyzeFile', ...[...featureMlCapabilitiesKeys, ...userMlCapabilitiesKeys].map(k => `ml:${k}`)],
      catalogue: [_app.PLUGIN_ID],
      management: {
        insightsAndAlerting: ['triggersActions']
      },
      ui: [...featureMlCapabilitiesKeys, ...userMlCapabilitiesKeys],
      savedObject: {
        all: [],
        read: savedObjects
      },
      alerting: {
        rule: {
          read: alertingFeatures
        },
        alert: {
          read: alertingFeatures
        }
      }
    },
    apmUser: {
      excludeFromBasePrivileges: true,
      app: [],
      catalogue: [],
      savedObject: {
        all: [],
        read: [_saved_objects.ML_JOB_SAVED_OBJECT_TYPE]
      },
      api: apmUserMlCapabilitiesKeys.map(k => `ml:${k}`),
      ui: apmUserMlCapabilitiesKeys
    }
  };
}
const featureCapabilities = exports.featureCapabilities = {
  ad: ['canGetJobs', 'canGetDatafeeds', 'canGetCalendars', 'canGetAnnotations', 'canCreateAnnotation', 'canDeleteAnnotation', 'canCreateJob', 'canDeleteJob', 'canOpenJob', 'canCloseJob', 'canResetJob', 'canUpdateJob', 'canForecastJob', 'canDeleteForecast', 'canCreateDatafeed', 'canDeleteDatafeed', 'canStartStopDatafeed', 'canUpdateDatafeed', 'canPreviewDatafeed', 'canGetFilters', 'canCreateCalendar', 'canDeleteCalendar', 'canCreateFilter', 'canDeleteFilter'],
  dfa: ['canGetDataFrameAnalytics', 'canCreateDataFrameAnalytics', 'canDeleteDataFrameAnalytics', 'canStartStopDataFrameAnalytics'],
  nlp: ['canGetTrainedModels', 'canTestTrainedModels', 'canCreateTrainedModels', 'canDeleteTrainedModels', 'canStartStopTrainedModels', 'canCreateInferenceEndpoint']
};