"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.formulas = void 0;
var _cpu = require("./cpu");
var _disk = require("./disk");
var _host_count = require("./host_count");
var _log_rate = require("./log_rate");
var _memory = require("./memory");
var _network = require("./network");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const formulas = exports.formulas = {
  cpuUsage: _cpu.cpuUsage,
  cpuUsageIowait: _cpu.cpuUsageIowait,
  cpuUsageIrq: _cpu.cpuUsageIrq,
  cpuUsageNice: _cpu.cpuUsageNice,
  cpuUsageSoftirq: _cpu.cpuUsageSoftirq,
  cpuUsageSteal: _cpu.cpuUsageSteal,
  cpuUsageUser: _cpu.cpuUsageUser,
  cpuUsageSystem: _cpu.cpuUsageSystem,
  diskIORead: _disk.diskIORead,
  diskIOWrite: _disk.diskIOWrite,
  diskReadThroughput: _disk.diskReadThroughput,
  diskWriteThroughput: _disk.diskWriteThroughput,
  diskSpaceAvailability: _disk.diskSpaceAvailability,
  diskSpaceAvailable: _disk.diskSpaceAvailable,
  diskUsage: _disk.diskUsage,
  diskUsageAverage: _disk.diskUsageAverage,
  hostCount: _host_count.hostCount,
  logRate: _log_rate.logRate,
  normalizedLoad1m: _cpu.normalizedLoad1m,
  load1m: _cpu.load1m,
  load5m: _cpu.load5m,
  load15m: _cpu.load15m,
  memoryUsage: _memory.memoryUsage,
  memoryFree: _memory.memoryFree,
  memoryUsed: _memory.memoryUsed,
  memoryFreeExcludingCache: _memory.memoryFreeExcludingCache,
  memoryCache: _memory.memoryCache,
  rx: _network.rx,
  tx: _network.tx
};