"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.cpu = void 0;
var _constants = require("../../../shared/charts/constants");
var _formulas = require("../formulas");
var _formulas$cpuUsage$la, _formulas$normalizedL, _formulas$cpuUsage$la2, _formulas$normalizedL2;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const cpuUsageBreakdown = {
  id: 'cpuUsageBreakdown',
  chartType: 'xy',
  title: _constants.CPU_USAGE_LABEL,
  layers: [{
    seriesType: 'area',
    type: 'series',
    xAxis: '@timestamp',
    yAxis: [_formulas.formulas.cpuUsageIowait, _formulas.formulas.cpuUsageIrq, _formulas.formulas.cpuUsageNice, _formulas.formulas.cpuUsageSoftirq, _formulas.formulas.cpuUsageSteal, _formulas.formulas.cpuUsageUser, _formulas.formulas.cpuUsageSystem]
  }],
  ..._constants.DEFAULT_XY_FITTING_FUNCTION,
  ..._constants.DEFAULT_XY_LEGEND,
  ..._constants.DEFAULT_XY_YBOUNDS,
  ..._constants.DEFAULT_XY_HIDDEN_AXIS_TITLE
};
const loadBreakdown = {
  id: 'loadBreakdown',
  chartType: 'xy',
  title: _constants.LOAD_LABEL,
  layers: [{
    seriesType: 'area',
    type: 'series',
    xAxis: '@timestamp',
    yAxis: [_formulas.formulas.load1m, _formulas.formulas.load5m, _formulas.formulas.load15m]
  }],
  ..._constants.DEFAULT_XY_FITTING_FUNCTION,
  ..._constants.DEFAULT_XY_LEGEND,
  ..._constants.DEFAULT_XY_HIDDEN_AXIS_TITLE
};
const cpuUsageXY = {
  id: 'cpuUsage',
  chartType: 'xy',
  title: (_formulas$cpuUsage$la = _formulas.formulas.cpuUsage.label) !== null && _formulas$cpuUsage$la !== void 0 ? _formulas$cpuUsage$la : '',
  layers: [{
    seriesType: 'line',
    type: 'series',
    xAxis: '@timestamp',
    yAxis: [_formulas.formulas.cpuUsage]
  }],
  ..._constants.DEFAULT_XY_FITTING_FUNCTION,
  ..._constants.DEFAULT_XY_HIDDEN_LEGEND,
  ..._constants.DEFAULT_XY_HIDDEN_AXIS_TITLE,
  ..._constants.DEFAULT_XY_YBOUNDS
};
const normalizedLoad1mXY = {
  id: 'normalizedLoad1m',
  chartType: 'xy',
  title: (_formulas$normalizedL = _formulas.formulas.normalizedLoad1m.label) !== null && _formulas$normalizedL !== void 0 ? _formulas$normalizedL : '',
  layers: [{
    seriesType: 'line',
    type: 'series',
    xAxis: '@timestamp',
    yAxis: [_formulas.formulas.normalizedLoad1m]
  }, {
    type: 'reference',
    yAxis: [{
      value: '1'
    }]
  }],
  ..._constants.DEFAULT_XY_FITTING_FUNCTION,
  ..._constants.DEFAULT_XY_HIDDEN_LEGEND,
  ..._constants.DEFAULT_XY_HIDDEN_AXIS_TITLE
};
const cpuUsageMetric = {
  id: 'cpuUsage',
  chartType: 'metric',
  title: (_formulas$cpuUsage$la2 = _formulas.formulas.cpuUsage.label) !== null && _formulas$cpuUsage$la2 !== void 0 ? _formulas$cpuUsage$la2 : '',
  trendLine: true,
  ..._formulas.formulas.cpuUsage
};
const normalizedLoad1mMetric = {
  id: 'normalizedLoad1m',
  chartType: 'metric',
  title: (_formulas$normalizedL2 = _formulas.formulas.normalizedLoad1m.label) !== null && _formulas$normalizedL2 !== void 0 ? _formulas$normalizedL2 : '',
  trendLine: true,
  ..._formulas.formulas.normalizedLoad1m
};
const cpu = exports.cpu = {
  xy: {
    cpuUsageBreakdown,
    loadBreakdown,
    cpuUsage: cpuUsageXY,
    normalizedLoad1m: normalizedLoad1mXY
  },
  metric: {
    cpuUsage: cpuUsageMetric,
    normalizedLoad1m: normalizedLoad1mMetric
  }
};