"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RightSideControls = RightSideControls;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _layer_control = require("./layer_control");
var _mouse_coordinates_control = require("./mouse_coordinates_control");
var _attribution_control = require("./attribution_control");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function RightSideControls({
  settings
}) {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    className: "mapWidgetOverlay",
    responsive: false,
    direction: "column",
    alignItems: "flexEnd",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: "mapWidgetOverlay__layerWrapper"
  }, !settings.hideLayerControl && /*#__PURE__*/_react.default.createElement(_layer_control.LayerControl, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, !settings.hideViewControl && /*#__PURE__*/_react.default.createElement(_mouse_coordinates_control.MouseCoordinatesControl, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_attribution_control.AttributionControl, null)));
}