"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TOCEntryButton = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _layer = require("../../../../../../classes/layers/layer");
var _layer_group = require("../../../../../../classes/layers/layer_group");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class TOCEntryButton extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "_isMounted", false);
    (0, _defineProperty2.default)(this, "state", {
      isFilteredByGlobalTime: false
    });
  }
  componentDidMount() {
    this._isMounted = true;
    this._loadIsFilteredByGlobalTime();
  }
  componentDidUpdate() {
    this._loadIsFilteredByGlobalTime();
  }
  componentWillUnmount() {
    this._isMounted = false;
  }
  async _loadIsFilteredByGlobalTime() {
    const isFilteredByGlobalTime = await this.props.layer.isFilteredByGlobalTime();
    if (this._isMounted && isFilteredByGlobalTime !== this.state.isFilteredByGlobalTime) {
      this.setState({
        isFilteredByGlobalTime
      });
    }
  }
  getIconAndTooltipContent() {
    const errors = this.props.layer.getErrors(this.props.inspectorAdapters);
    if (errors.length) {
      const errorIcon = /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        size: "m",
        type: "error",
        color: "danger",
        "data-test-subj": `layerTocErrorIcon${this.props.escapedDisplayName}`
      });
      return (0, _layer_group.isLayerGroup)(this.props.layer) ? {
        icon: errorIcon,
        footnotes: [],
        postScript: errors[0].title
      } : {
        icon: errorIcon,
        tooltipContent: this.props.layer.getErrors(this.props.inspectorAdapters).map(({
          title
        }) => /*#__PURE__*/_react.default.createElement("div", {
          key: title
        }, title)),
        footnotes: []
      };
    }
    if (!this.props.layer.isVisible()) {
      return {
        icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          size: "m",
          type: "eyeClosed"
        }),
        tooltipContent: _i18n.i18n.translate('xpack.maps.layer.layerHiddenTooltip', {
          defaultMessage: `Layer is hidden.`
        }),
        footnotes: []
      };
    }
    if (!this.props.layer.showAtZoomLevel(this.props.zoom)) {
      const minZoom = this.props.layer.getMinZoom();
      const maxZoom = this.props.layer.getMaxZoom();
      return {
        icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          size: "m",
          type: "expand"
        }),
        tooltipContent: _i18n.i18n.translate('xpack.maps.layer.zoomFeedbackTooltip', {
          defaultMessage: `Layer is visible between zoom levels {minZoom} and {maxZoom}.`,
          values: {
            minZoom,
            maxZoom
          }
        }),
        footnotes: []
      };
    }
    if (this.props.layer.isLayerLoading(this.props.zoom)) {
      return {
        icon: /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
          size: "m"
        }),
        tooltipContent: '',
        footnotes: []
      };
    }
    const {
      icon: layerIcon,
      tooltipContent
    } = this.props.layer.getLayerIcon(true);
    const warnings = this.props.layer.getWarnings();
    const icon = warnings.length ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "m",
      type: "warning",
      color: "warning",
      "data-test-subj": `layerTocWarningIcon${this.props.escapedDisplayName}`
    }) : layerIcon;
    if ((0, _layer_group.isLayerGroup)(this.props.layer)) {
      return {
        icon,
        tooltipContent,
        footnotes: [],
        postScript: warnings.length ? warnings[0].title : undefined
      };
    }
    const footnotes = [];
    if (this.props.isUsingSearch && this.props.layer.getQueryableIndexPatternIds().length) {
      footnotes.push({
        icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          color: "subdued",
          type: "filter",
          size: "s"
        }),
        message: _i18n.i18n.translate('xpack.maps.layer.isUsingSearchMsg', {
          defaultMessage: 'Results narrowed by global search'
        })
      });
    }
    if (this.state.isFilteredByGlobalTime) {
      footnotes.push({
        icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          color: "subdued",
          type: "clock",
          size: "s"
        }),
        message: _i18n.i18n.translate('xpack.maps.layer.isUsingTimeFilter', {
          defaultMessage: 'Results narrowed by global time'
        })
      });
    }
    const source = this.props.layer.getSource();
    if (typeof source.isFilterByMapBounds === 'function' && source.isFilterByMapBounds()) {
      footnotes.push({
        icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          color: "subdued",
          type: "stop",
          size: "s"
        }),
        message: _i18n.i18n.translate('xpack.maps.layer.isUsingBoundsFilter', {
          defaultMessage: 'Results narrowed by visible map area'
        })
      });
    }
    return {
      icon,
      tooltipContent,
      footnotes,
      postScript: warnings.length ? _layer.INCOMPLETE_RESULTS_WARNING : undefined
    };
  }
  render() {
    const {
      icon,
      tooltipContent,
      footnotes,
      postScript
    } = this.getIconAndTooltipContent();
    const footnoteIcons = footnotes.map((footnote, index) => {
      return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
        key: index
      }, '', footnote.icon);
    });
    const footnoteTooltipContent = footnotes.map((footnote, index) => {
      return /*#__PURE__*/_react.default.createElement("div", {
        key: index
      }, footnote.icon, " ", footnote.message);
    });
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      anchorClassName: "mapLayTocActions__tooltipAnchor",
      position: "top",
      title: this.props.displayName,
      content: /*#__PURE__*/_react.default.createElement(_react.Fragment, null, tooltipContent, footnoteTooltipContent, postScript ? /*#__PURE__*/_react.default.createElement("p", {
        style: {
          fontStyle: 'italic',
          marginTop: '16px'
        }
      }, postScript) : null),
      "data-test-subj": "layerTocTooltip"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      className: "mapTocEntry__layerName eui-textLeft",
      size: "xs",
      flush: "left",
      color: "text",
      onClick: this.props.onClick,
      "data-test-subj": `layerTocActionsPanelToggleButton${this.props.escapedDisplayName}`
    }, /*#__PURE__*/_react.default.createElement("span", {
      className: "mapTocEntry__layerNameIcon"
    }, icon), this.props.displayName, " ", footnoteIcons));
  }
}
exports.TOCEntryButton = TOCEntryButton;