"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GeoFieldSelect = GeoFieldSelect;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _single_field_select = require("./single_field_select");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function GeoFieldSelect(props) {
  const {
    geoFields,
    ...rest
  } = props;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.maps.source.geofieldLabel', {
      defaultMessage: 'Geospatial field'
    })
  }, /*#__PURE__*/_react.default.createElement(_single_field_select.SingleFieldSelect, (0, _extends2.default)({
    placeholder: _i18n.i18n.translate('xpack.maps.source.selectLabel', {
      defaultMessage: 'Select geo field'
    }),
    fields: props.geoFields
  }, rest)));
}