"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StaticIconProperty = void 0;
var _static_style_property = require("./static_style_property");
var _symbol_utils = require("../symbol_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class StaticIconProperty extends _static_style_property.StaticStyleProperty {
  syncIconWithMb(symbolLayerId, mbMap) {
    mbMap.setLayoutProperty(symbolLayerId, 'icon-anchor', this.getSymbolAnchor());
    mbMap.setLayoutProperty(symbolLayerId, 'icon-image', this._options.value);
  }
  getSymbolAnchor() {
    return (0, _symbol_utils.getMakiSymbolAnchor)(this._options.value);
  }
}
exports.StaticIconProperty = StaticIconProperty;