"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sourceTitle = exports.XYZTMSSource = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _i18n_getters = require("../../../../common/i18n_getters");
var _constants = require("../../../../common/constants");
var _source = require("../source");
var _can_skip_fetch = require("../../util/can_skip_fetch");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const sourceTitle = exports.sourceTitle = _i18n.i18n.translate('xpack.maps.source.ems_xyzTitle', {
  defaultMessage: 'Tile Map Service'
});
class XYZTMSSource extends _source.AbstractSource {
  static createDescriptor({
    urlTemplate
  }) {
    return {
      type: XYZTMSSource.type,
      urlTemplate
    };
  }
  constructor(sourceDescriptor) {
    super(sourceDescriptor);
    (0, _defineProperty2.default)(this, "_descriptor", void 0);
    this._descriptor = sourceDescriptor;
  }
  async getImmutableProperties() {
    return [{
      label: (0, _i18n_getters.getDataSourceLabel)(),
      value: sourceTitle
    }, {
      label: (0, _i18n_getters.getUrlLabel)(),
      value: this._descriptor.urlTemplate
    }];
  }
  async getDisplayName() {
    return this._descriptor.urlTemplate;
  }
  async getUrlTemplate() {
    return this._descriptor.urlTemplate;
  }
  async hasLegendDetails() {
    return false;
  }
  renderLegendDetails() {
    return null;
  }
  isSourceStale(mbSource, sourceData) {
    var _mbSource$tiles;
    if (!sourceData.url) {
      return false;
    }
    return ((_mbSource$tiles = mbSource.tiles) === null || _mbSource$tiles === void 0 ? void 0 : _mbSource$tiles[0]) !== sourceData.url;
  }
  async canSkipSourceUpdate(prevDataRequest, nextMeta) {
    const prevMeta = prevDataRequest === null || prevDataRequest === void 0 ? void 0 : prevDataRequest.getMeta();
    const canSkip = await (0, _can_skip_fetch.canSkipSourceUpdate)({
      extentAware: false,
      source: this,
      prevDataRequest,
      nextRequestMeta: nextMeta,
      getUpdateDueToTimeslice: timeslice => {
        if (!prevMeta) return true;
        return this.getUpdateDueToTimeslice(prevMeta, timeslice);
      }
    });
    return canSkip;
  }
}
exports.XYZTMSSource = XYZTMSSource;
(0, _defineProperty2.default)(XYZTMSSource, "type", _constants.SOURCE_TYPES.EMS_XYZ);