"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EnableMonitoringAlert = EnableMonitoringAlert;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function EnableMonitoringAlert() {
  return /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.logstash.enableMonitoringAlert.enableMonitoringTitle",
    defaultMessage: "Enable monitoring."
  })), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.logstash.enableMonitoringAlert.enableMonitoringDescription",
    defaultMessage: "In the {configFileName} file, set {monitoringConfigParam} and {monitoringUiConfigParam} to {trueValue}.",
    values: {
      configFileName: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "kibana.yml"),
      monitoringConfigParam: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "xpack.monitoring.enabled"),
      monitoringUiConfigParam: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "xpack.monitoring.ui.enabled"),
      trueValue: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "true")
    }
  }));
}