"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLogSourcesSettingDeprecationInfoForSpaceFactory = exports.getLogSourcesSettingDeprecationInfo = void 0;
var _pMap = _interopRequireDefault(require("p-map"));
var _i18n = require("@kbn/i18n");
var _deprecations = require("../../common/http_api/deprecations");
var _constants = require("./constants");
var _log_views = require("../../common/log_views");
var _common = require("../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getLogSourcesSettingDeprecationInfo = async params => {
  const [_, pluginStartDeps] = await params.getStartServices();
  const allAvailableSpaces = await pluginStartDeps.spaces.spacesService.createSpacesClient(params.context.request).getAll({
    purpose: 'any'
  });
  const deprecationPerSpaceFactory = getLogSourcesSettingDeprecationInfoForSpaceFactory(params);
  const results = await (0, _pMap.default)(allAvailableSpaces, deprecationPerSpaceFactory, {
    concurrency: _constants.CONCURRENT_SPACES_TO_CHECK // limit the number of spaces handled concurrently to make sure that we cover large deployments
  });
  const offendingSpaces = results.filter(Boolean);
  if (offendingSpaces.length) {
    const shortList = offendingSpaces.length < 4 ? offendingSpaces.join(', ') : `${offendingSpaces.slice(0, 3).join(', ')}, ...`;
    const fullList = offendingSpaces.join(', ');
    return [{
      title: _i18n.i18n.translate('xpack.logsShared.deprecations.migrateLogViewSettingsToLogSourcesSetting.title', {
        defaultMessage: 'Log sources setting in {count} spaces: {shortList}',
        values: {
          count: offendingSpaces.length,
          shortList
        }
      }),
      level: 'warning',
      deprecationType: 'feature',
      message: _i18n.i18n.translate('xpack.logsShared.deprecations.migrateLogViewSettingsToLogSourcesSetting.message', {
        defaultMessage: 'Indices and Data view options previously provided via the Logs UI settings page are now deprecated. Please migrate to using the Kibana log sources advanced setting in each of the following spaces: {fullList}.',
        values: {
          fullList
        }
      }),
      correctiveActions: {
        manualSteps: offendingSpaces.map(spaceName => _i18n.i18n.translate('xpack.logsShared.deprecations.migrateLogViewSettingsToLogSourcesSetting.message.manualStepMessage', {
          defaultMessage: 'While in the space "{spaceName}" update the Log sources Kibana advanced setting (via Management > Advanced Settings) to match the setting previously provided via the Logs UI settings page. Then via the Logs UI settings page use the Kibana log sources advanced setting option.',
          values: {
            spaceName
          }
        })),
        api: {
          method: 'PUT',
          path: _deprecations.MIGRATE_LOG_VIEW_SETTINGS_URL
        }
      }
    }];
  } else {
    return [];
  }
};
exports.getLogSourcesSettingDeprecationInfo = getLogSourcesSettingDeprecationInfo;
const getLogSourcesSettingDeprecationInfoForSpaceFactory = ({
  getStartServices,
  context
}) => {
  return async space => {
    const [_, pluginStartDeps, pluginStart] = await getStartServices();

    // Get a new Saved Object Client scoped to the space.id
    const spaceScopedSavedObjectsClient = context.savedObjectsClient.asScopedToNamespace(space.id);
    const logSourcesService = pluginStartDeps.logsDataAccess.services.logSourcesServiceFactory.getLogSourcesService(spaceScopedSavedObjectsClient);
    const logViewsClient = pluginStart.logViews.getClient(spaceScopedSavedObjectsClient, context.esClient.asCurrentUser, logSourcesService);
    const logView = await logViewsClient.getLogView(_log_views.defaultLogViewId);
    if (logView && !_common.logSourcesKibanaAdvancedSettingRT.is(logView.attributes.logIndices)) {
      return space.name;
    }
  };
};
exports.getLogSourcesSettingDeprecationInfoForSpaceFactory = getLogSourcesSettingDeprecationInfoForSpaceFactory;