"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.logViewNotificationEventSelectors = exports.createLogViewNotificationChannel = void 0;
var _xstate_helpers = require("../../xstate_helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createLogViewNotificationChannel = () => (0, _xstate_helpers.createNotificationChannel)();
exports.createLogViewNotificationChannel = createLogViewNotificationChannel;
const logViewNotificationEventSelectors = exports.logViewNotificationEventSelectors = {
  loadingLogViewStarted: context => 'logViewReference' in context ? {
    type: 'LOADING_LOG_VIEW_STARTED',
    logViewReference: context.logViewReference
  } : undefined,
  loadingLogViewSucceeded: context => 'resolvedLogView' in context && 'status' in context ? {
    type: 'LOADING_LOG_VIEW_SUCCEEDED',
    resolvedLogView: context.resolvedLogView,
    status: context.status
  } : undefined,
  loadingLogViewFailed: context => 'error' in context ? {
    type: 'LOADING_LOG_VIEW_FAILED',
    error: context.error
  } : undefined
};