"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLogSummary = void 0;
var _react = require("react");
var _rxjs = require("rxjs");
var _use_observable = require("../../../utils/use_observable");
var _fetch_log_summary = require("./api/fetch_log_summary");
var _bucket_size = require("./bucket_size");
var _use_kibana = require("../../../hooks/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useLogSummary = (logViewReference, startTimestamp, endTimestamp, filterQuery) => {
  const {
    services
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const bucketSize = (0, _bucket_size.useBucketSize)(startTimestamp, endTimestamp);
  const [logSummaryBuckets$, pushLogSummaryBucketsArgs] = (0, _use_observable.useReplaySubject)(fetchLogSummary$);
  const {
    latestValue: logSummaryBuckets
  } = (0, _use_observable.useObservableState)(logSummaryBuckets$, NO_BUCKETS);
  (0, _react.useEffect)(() => {
    if (startTimestamp === null || endTimestamp === null || bucketSize === null) {
      return;
    }
    pushLogSummaryBucketsArgs([{
      logView: logViewReference,
      startTimestamp,
      endTimestamp,
      bucketSize,
      query: filterQuery
    }, services.http.fetch]);
  }, [bucketSize, endTimestamp, filterQuery, pushLogSummaryBucketsArgs, services.http.fetch, logViewReference, startTimestamp]);
  return {
    buckets: logSummaryBuckets,
    start: startTimestamp,
    end: endTimestamp
  };
};
exports.useLogSummary = useLogSummary;
const NO_BUCKETS = [];
const fetchLogSummary$ = fetchArguments$ => fetchArguments$.pipe((0, _rxjs.exhaustMap)(([args, fetch]) => (0, _fetch_log_summary.fetchLogSummary)(args, fetch)), (0, _rxjs.map)(({
  data: {
    buckets
  }
}) => buckets));