"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.LogEntryMessageColumn = void 0;
var _react = _interopRequireWildcard(require("react"));
var _common = require("@kbn/kibana-react-plugin/common");
var _log_entry = require("../../../utils/log_entry");
var _field_value = require("./field_value");
var _log_entry_column = require("./log_entry_column");
var _text_styles = require("./text_styles");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LogEntryMessageColumn = exports.LogEntryMessageColumn = /*#__PURE__*/(0, _react.memo)(({
  columnValue,
  highlights,
  isActiveHighlight,
  wrapMode,
  render
}) => {
  const message = (0, _react.useMemo)(() => (0, _log_entry.isMessageColumn)(columnValue) ? formatMessageSegments(columnValue.message, highlights, isActiveHighlight) : null, [columnValue, highlights, isActiveHighlight]);
  const messageAsString = (0, _react.useMemo)(() => (0, _log_entry.isMessageColumn)(columnValue) ? renderMessageSegments(columnValue.message) : '', [columnValue]);
  return /*#__PURE__*/_react.default.createElement(MessageColumnContent, {
    wrapMode: wrapMode
  }, render ? render(messageAsString) : message);
});
const MessageColumnContent = (0, _common.euiStyled)(_log_entry_column.LogEntryColumnContent)`
  text-overflow: ellipsis;
  ${props => props.wrapMode === 'long' ? _text_styles.longWrappedContentStyle : props.wrapMode === 'pre-wrapped' ? _text_styles.preWrappedContentStyle : _text_styles.unwrappedContentStyle};
`;
const formatMessageSegments = (messageSegments, highlights, isActiveHighlight) => messageSegments.map((messageSegment, index) => {
  if ((0, _log_entry.isFieldSegment)(messageSegment)) {
    // we only support one highlight for now
    const [firstHighlight = []] = highlights.map(highlight => {
      if ((0, _log_entry.isHighlightMessageColumn)(highlight)) {
        const segment = highlight.message[index];
        if ((0, _log_entry.isHighlightFieldSegment)(segment)) {
          return segment.highlights;
        }
      }
      return [];
    });
    return /*#__PURE__*/_react.default.createElement(_field_value.FieldValue, {
      highlightTerms: firstHighlight,
      isActiveHighlight: isActiveHighlight,
      key: `MessageSegment-${index}`,
      value: messageSegment.value
    });
  } else if ((0, _log_entry.isConstantSegment)(messageSegment)) {
    return messageSegment.constant;
  }
  return 'failed to format message';
});
const renderMessageSegments = messageSegments => {
  return messageSegments.map(messageSegment => {
    if ((0, _log_entry.isConstantSegment)(messageSegment)) {
      return messageSegment.constant;
    }
    if ((0, _log_entry.isFieldSegment)(messageSegment)) {
      return messageSegment.value.toString();
    }
  }).join(' ');
};

// eslint-disable-next-line import/no-default-export
var _default = exports.default = LogEntryMessageColumn;