"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "createPlainError", {
  enumerable: true,
  get: function () {
    return _ioTsUtils.createPlainError;
  }
});
exports.createValidationFunction = void 0;
Object.defineProperty(exports, "decodeOrThrow", {
  enumerable: true,
  get: function () {
    return _ioTsUtils.decodeOrThrow;
  }
});
Object.defineProperty(exports, "formatErrors", {
  enumerable: true,
  get: function () {
    return _ioTsUtils.formatErrors;
  }
});
Object.defineProperty(exports, "throwErrors", {
  enumerable: true,
  get: function () {
    return _ioTsUtils.throwErrors;
  }
});
var _ioTsUtils = require("@kbn/io-ts-utils");
var _Either = require("fp-ts/lib/Either");
var _pipeable = require("fp-ts/lib/pipeable");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createValidationFunction = runtimeType => (inputValue, {
  badRequest,
  ok
}) => (0, _pipeable.pipe)(runtimeType.decode(inputValue), (0, _Either.fold)(errors => badRequest((0, _ioTsUtils.formatErrors)(errors)), result => ok(result)));
exports.createValidationFunction = createValidationFunction;