"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogsLocatorDefinition = exports.LOGS_LOCATOR_ID = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _deeplinksObservability = require("@kbn/deeplinks-observability");
var _helpers = require("./helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LOGS_LOCATOR_ID = exports.LOGS_LOCATOR_ID = 'LOGS_LOCATOR';
class LogsLocatorDefinition {
  constructor(locators) {
    (0, _defineProperty2.default)(this, "id", LOGS_LOCATOR_ID);
    (0, _defineProperty2.default)(this, "getLocation", async params => {
      const allDatasetsLocator = this.locators.get(_deeplinksObservability.ALL_DATASETS_LOCATOR_ID);
      const {
        time
      } = params;
      return allDatasetsLocator.getLocation({
        query: (0, _helpers.getLogsQuery)(params),
        ...(time ? {
          timeRange: {
            from: (0, _helpers.getTimeRangeStartFromTime)(time),
            to: (0, _helpers.getTimeRangeEndFromTime)(time)
          }
        } : {})
      });
    });
    this.locators = locators;
  }
}
exports.LogsLocatorDefinition = LogsLocatorDefinition;