"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DiscoverLogsLocatorDefinition = exports.DISCOVER_LOGS_LOCATOR_ID = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Locator used to link to all log sources in Discover.
 */
const DISCOVER_LOGS_LOCATOR_ID = exports.DISCOVER_LOGS_LOCATOR_ID = 'DISCOVER_LOGS_LOCATOR';

/**
 * Accepts the same parameters as `DiscoverAppLocatorParams`, but automatically sets the `dataViewSpec` param to all log sources.
 */

class DiscoverLogsLocatorDefinition {
  constructor(deps) {
    (0, _defineProperty2.default)(this, "id", DISCOVER_LOGS_LOCATOR_ID);
    (0, _defineProperty2.default)(this, "getLocation", async params => {
      var _params$dataViewSpec;
      const discoverAppLocator = this.deps.locators.get('DISCOVER_APP_LOCATOR');
      return discoverAppLocator.getLocation({
        dataViewSpec: (_params$dataViewSpec = params.dataViewSpec) !== null && _params$dataViewSpec !== void 0 ? _params$dataViewSpec : await this.getLogSourcesDataViewSpec(),
        ...params
      });
    });
    this.deps = deps;
  }
  async getLogSourcesDataViewSpec() {
    const logSourcesService = await this.deps.getLogSourcesService();
    const logSources = await logSourcesService.getLogSources();
    return {
      title: logSources.map(logSource => logSource.indexPattern).join(','),
      timeFieldName: '@timestamp'
    };
  }
}
exports.DiscoverLogsLocatorDefinition = DiscoverLogsLocatorDefinition;