"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateDiscoverAppStateFromContext = exports.updateContextFromDiscoverDataState = exports.updateContextFromDiscoverAppState = exports.subscribeToDiscoverState = exports.redirectToDiscover = void 0;
var _lodash = require("lodash");
var _xstate = require("xstate");
var _data_source_selection = require("../../../../../common/data_source_selection");
var _convert_discover_app_state = require("../../../../utils/convert_discover_app_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const subscribeToDiscoverState = () => context => (send, onEvent) => {
  if (!('discoverStateContainer' in context)) {
    throw new Error('Failed to subscribe to the Discover state: no state container in context.');
  }
  const {
    appState,
    dataState
  } = context.discoverStateContainer;
  const appStateSubscription = appState.state$.subscribe({
    next: newAppState => {
      if ((0, _lodash.isEmpty)(newAppState)) {
        return;
      }
      send({
        type: 'RECEIVE_DISCOVER_APP_STATE',
        appState: newAppState
      });
    }
  });
  const dataStateSubscription = dataState.data$.documents$.subscribe({
    next: newDataState => {
      if (!(0, _lodash.isEmpty)(newDataState === null || newDataState === void 0 ? void 0 : newDataState.result)) {
        send({
          type: 'RECEIVE_DISCOVER_DATA_STATE',
          dataState: newDataState.result
        });
      }
    }
  });
  return () => {
    appStateSubscription.unsubscribe();
    dataStateSubscription.unsubscribe();
  };
};
exports.subscribeToDiscoverState = subscribeToDiscoverState;
const updateContextFromDiscoverAppState = exports.updateContextFromDiscoverAppState = _xstate.actions.assign((context, event) => {
  if ('appState' in event && event.type === 'RECEIVE_DISCOVER_APP_STATE') {
    var _getGridColumnDisplay;
    return {
      chart: {
        ...context.chart,
        ...(0, _convert_discover_app_state.getChartDisplayOptionsFromDiscoverAppState)(event.appState)
      },
      grid: {
        columns: (_getGridColumnDisplay = (0, _convert_discover_app_state.getGridColumnDisplayOptionsFromDiscoverAppState)(event.appState)) !== null && _getGridColumnDisplay !== void 0 ? _getGridColumnDisplay : context.grid.columns,
        rows: {
          ...context.grid.rows,
          ...(0, _convert_discover_app_state.getGridRowsDisplayOptionsFromDiscoverAppState)(event.appState)
        }
      },
      ...(0, _convert_discover_app_state.getQueryStateFromDiscoverAppState)(event.appState)
    };
  }
  return {};
});
const updateContextFromDiscoverDataState = exports.updateContextFromDiscoverDataState = _xstate.actions.assign((context, event) => {
  if ('dataState' in event && event.type === 'RECEIVE_DISCOVER_DATA_STATE') {
    return {
      rows: event.dataState
    };
  }
  return {};
});
const updateDiscoverAppStateFromContext = (context, _event) => {
  if (!('discoverStateContainer' in context)) {
    return;
  }
  context.discoverStateContainer.appState.update((0, _convert_discover_app_state.getDiscoverAppStateFromContext)(context));
};
exports.updateDiscoverAppStateFromContext = updateDiscoverAppStateFromContext;
const redirectToDiscover = events => (context, event) => {
  if (event.type === 'UPDATE_DATA_SOURCE_SELECTION' && (0, _data_source_selection.isDataViewSelection)(event.data)) {
    if (events !== null && events !== void 0 && events.onUknownDataViewSelection) {
      return events.onUknownDataViewSelection({
        ...context,
        dataSourceSelection: event.data
      });
    }
  }
};
exports.redirectToDiscover = redirectToDiscover;