"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createCustomSearchBar = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createCustomSearchBar = ({
  navigation,
  data,
  unifiedSearch
}) => {
  const {
    ui: {
      createTopNavWithCustomContext
    }
  } = navigation;
  const {
    ui: {
      getCustomSearchBar
    }
  } = unifiedSearch;
  const CustomSearchBar = getCustomSearchBar(data);
  const customUnifiedSearch = {
    ...unifiedSearch,
    ui: {
      ...unifiedSearch.ui,
      SearchBar: CustomSearchBar,
      AggregateQuerySearchBar: CustomSearchBar
    }
  };
  return createTopNavWithCustomContext(customUnifiedSearch);
};
exports.createCustomSearchBar = createCustomSearchBar;