"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.unresolvedDatasetSelectionPlainRT = exports.singleDatasetSelectionPlainRT = exports.dataViewSelectionPlainRT = exports.dataSourceSelectionPlainRT = exports.allDatasetSelectionPlainRT = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _datasets = require("../datasets");
var _types = require("../data_views/types");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const integrationNameRT = rt.partial({
  name: rt.string
});
const integrationTitleRT = rt.partial({
  title: rt.string
});
const integrationVersionRT = rt.partial({
  version: rt.string
});
const singleDatasetSelectionPayloadRT = rt.intersection([integrationNameRT, integrationTitleRT, integrationVersionRT, rt.type({
  dataset: _datasets.datasetRT
})]);
const dataViewSelectionPayloadRT = rt.type({
  dataView: _types.dataViewDescriptorRT
});
const unresolvedDatasetSelectionPayloadRT = rt.intersection([integrationNameRT, rt.type({
  dataset: _datasets.datasetRT
})]);
const allDatasetSelectionPlainRT = exports.allDatasetSelectionPlainRT = rt.type({
  selectionType: rt.literal('all')
});
const dataViewSelectionPlainRT = exports.dataViewSelectionPlainRT = rt.type({
  selectionType: rt.literal('dataView'),
  selection: dataViewSelectionPayloadRT
});
const singleDatasetSelectionPlainRT = exports.singleDatasetSelectionPlainRT = rt.type({
  selectionType: rt.literal('single'),
  selection: singleDatasetSelectionPayloadRT
});
const unresolvedDatasetSelectionPlainRT = exports.unresolvedDatasetSelectionPlainRT = rt.type({
  selectionType: rt.literal('unresolved'),
  selection: unresolvedDatasetSelectionPayloadRT
});
const dataSourceSelectionPlainRT = exports.dataSourceSelectionPlainRT = rt.union([allDatasetSelectionPlainRT, dataViewSelectionPlainRT, singleDatasetSelectionPlainRT, unresolvedDatasetSelectionPlainRT]);