"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataViewSelection = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _data_view_descriptor = require("../data_views/models/data_view_descriptor");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class DataViewSelection {
  constructor(dataViewDescriptor) {
    (0, _defineProperty2.default)(this, "selectionType", void 0);
    (0, _defineProperty2.default)(this, "selection", void 0);
    this.selectionType = 'dataView';
    this.selection = {
      dataView: dataViewDescriptor
    };
  }
  toDataviewSpec() {
    return this.selection.dataView.toDataviewSpec();
  }
  toPlainSelection() {
    return {
      selectionType: this.selectionType,
      selection: {
        dataView: this.selection.dataView.toPlain()
      }
    };
  }
  static fromSelection(selection) {
    const {
      dataView
    } = selection;
    const dataViewDescriptor = _data_view_descriptor.DataViewDescriptor.create(dataView);
    return DataViewSelection.create(dataViewDescriptor);
  }
  static create(dataViewDescriptor) {
    return new DataViewSelection(dataViewDescriptor);
  }
}
exports.DataViewSelection = DataViewSelection;