"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RequestTrialExtension = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RequestTrialExtension = ({
  shouldShowRequestTrialExtension
}) => {
  if (!shouldShowRequestTrialExtension) {
    return null;
  }
  const description = /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.licenseMgmt.licenseDashboard.requestTrialExtension.howToContinueUsingPluginsDescription",
    defaultMessage: "If you\u2019d like to continue using machine learning, advanced security, and our other awesome {subscriptionFeaturesLinkText}, request an extension now.",
    values: {
      subscriptionFeaturesLinkText: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: _constants.EXTERNAL_LINKS.SUBSCRIPTIONS,
        target: "_blank"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.licenseMgmt.licenseDashboard.requestTrialExtension.subscriptionFeaturesLinkText",
        defaultMessage: "subscription features"
      }))
    }
  }));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    hasBorder: true,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.licenseMgmt.licenseDashboard.requestTrialExtension.extendYourTrialTitle",
      defaultMessage: "Extend your trial"
    }),
    description: description,
    footer: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "extendTrialButton",
      target: "_blank",
      href: _constants.EXTERNAL_LINKS.TRIAL_EXTENSION
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.licenseMgmt.licenseDashboard.requestTrialExtension.extendTrialButtonLabel",
      defaultMessage: "Extend trial"
    }))
  }));
};
exports.RequestTrialExtension = RequestTrialExtension;