"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LayerSettings = LayerSettings;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function LayerSettings(props) {
  if (props.section === 'appearance') {
    return null;
  }
  if (props.state.shape === _constants.PieChartTypes.MOSAIC) {
    return null;
  }
  const currentLayer = props.state.layers.find(layer => layer.layerId === props.layerId);
  if (!currentLayer) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    display: "columnCompressed",
    label: _i18n.i18n.translate('xpack.lens.pieChart.multipleMetrics', {
      defaultMessage: 'Multiple metrics'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: _i18n.i18n.translate('xpack.lens.pieChart.multipleMetrics', {
      defaultMessage: 'Multiple metrics'
    }),
    compressed: true,
    showLabel: false,
    checked: Boolean(currentLayer.allowMultipleMetrics),
    onChange: () => {
      props.setState({
        ...props.state,
        layers: props.state.layers.map(layer => layer.layerId !== props.layerId ? layer : {
          ...layer,
          allowMultipleMetrics: !layer.allowMultipleMetrics
        })
      });
    }
  }));
}