"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLensClient = getLensClient;
var _constants = require("../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getLensClient(cm) {
  const get = async id => {
    return cm.client.get({
      contentTypeId: _constants.DOC_TYPE,
      id
    });
  };
  const create = async ({
    data,
    options
  }) => {
    const res = await cm.client.create({
      contentTypeId: _constants.DOC_TYPE,
      data,
      options
    });
    return res;
  };
  const update = async ({
    id,
    data,
    options
  }) => {
    const res = await cm.client.update({
      contentTypeId: _constants.DOC_TYPE,
      id,
      data,
      options
    });
    return res;
  };
  const deleteLens = async id => {
    const res = await cm.client.delete({
      contentTypeId: _constants.DOC_TYPE,
      id
    });
    return res;
  };
  const search = async (query = {}, options) => {
    return cm.client.search({
      contentTypeId: _constants.DOC_TYPE,
      query,
      options
    });
  };
  return {
    get,
    create,
    update,
    delete: deleteLens,
    search
  };
}