"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.addHelpMenuToAppChrome = addHelpMenuToAppChrome;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function addHelpMenuToAppChrome(chrome, docLinks) {
  chrome.setHelpExtension({
    appName: 'Lens',
    links: [{
      linkType: 'documentation',
      href: docLinks.links.visualize.lensPanels
    }, {
      linkType: 'github',
      title: '[Lens]',
      labels: ['Feature:Lens']
    }]
  });
}