"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.addCommasToNumber = addCommasToNumber;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Add commas as thousands separators to a number.
 *
 * @param  {Number} num
 * @return {String} num in string with commas as thousands separaters
 */
function addCommasToNumber(num) {
  return num.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ',');
}