"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TreeViewContainer = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _styles = require("./styles");
var _tree_nav = require("./tree_nav");
var _breadcrumb = require("./breadcrumb");
var _contexts = require("./contexts");
var _empty_state = require("./empty_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TreeViewContainer = ({
  globalFilter,
  renderSessionsView,
  indexPattern
}) => {
  return /*#__PURE__*/_react.default.createElement(_contexts.TreeViewContextProvider, {
    indexPattern: indexPattern,
    globalFilter: globalFilter
  }, /*#__PURE__*/_react.default.createElement(TreeViewContainerComponent, {
    renderSessionsView: renderSessionsView
  }));
};
exports.TreeViewContainer = TreeViewContainer;
const TreeViewContainerComponent = ({
  renderSessionsView
}) => {
  const styles = (0, _styles.useStyles)();
  const {
    treeNavSelection,
    sessionViewFilter,
    onTreeNavSelect,
    noResults
  } = (0, _contexts.useTreeViewContext)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Outer, {
    direction: "row",
    hasBorder: true,
    borderRadius: "m",
    css: styles.outerPanel
  }, noResults && /*#__PURE__*/_react.default.createElement(_empty_state.EmptyState, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    hidden: noResults,
    color: "subdued",
    grow: false,
    css: styles.navPanel
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_tree_nav.TreeNav, null))), /*#__PURE__*/_react.default.createElement(_eui.EuiSplitPanel.Inner, {
    hidden: noResults,
    css: styles.sessionsPanel
  }, /*#__PURE__*/_react.default.createElement(_breadcrumb.Breadcrumb, {
    treeNavSelection: treeNavSelection,
    onSelect: onTreeNavSelect
  }), renderSessionsView(sessionViewFilter)));
};