"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDarkMode = void 0;
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _context = require("../context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * This should only be used to pass the darkMode to a theme provider which is outside
 * of the global theme provider scope. For example when used with `EuiThemeProvider`.
 *
 * @deprecated
 */
const useDarkMode = defaultValue => {
  const {
    services: {
      theme
    }
  } = (0, _context.useKibana)();
  if (!theme) {
    if (defaultValue !== undefined) {
      return defaultValue;
    }
    throw new TypeError('theme service not available in kibana-react context.');
  }
  const currentTheme = (0, _useObservable.default)(theme.theme$, theme.getTheme());
  return currentTheme.darkMode;
};
exports.useDarkMode = useDarkMode;