"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NewsFeed = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const NewsFeed = ({
  newsFetchResult
}) => /*#__PURE__*/_react.default.createElement("section", {
  "aria-labelledby": "kbnOverviewNews__title",
  className: "kbnOverviewNews"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
  size: "s"
}, /*#__PURE__*/_react.default.createElement("h2", {
  id: "kbnOverviewNews__title"
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "kibanaOverview.news.title",
  defaultMessage: "What's new"
}))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
  size: "m"
}), /*#__PURE__*/_react.default.createElement("div", {
  className: "kbnOverviewNews__content"
}, newsFetchResult.feedItems.slice(0, 3).map(({
  title,
  description,
  linkUrl,
  publishOn
}, index) => /*#__PURE__*/_react.default.createElement("article", {
  key: title,
  "aria-labelledby": `kbnOverviewNews__title${index}`
}, /*#__PURE__*/_react.default.createElement("header", null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
  size: "xxs"
}, /*#__PURE__*/_react.default.createElement("h3", {
  id: `kbnOverviewNews__title${index}`
}, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
  href: linkUrl,
  target: "_blank"
}, title))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "xs",
  color: "subdued"
}, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement("time", {
  dateTime: publishOn.format('YYYY-MM-DD')
}, publishOn.format('DD MMMM YYYY'))))), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
  size: "xs"
}, /*#__PURE__*/_react.default.createElement("p", null, description))))));
exports.NewsFeed = NewsFeed;