"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createAgentInput = createAgentInput;
var _path = require("path");
var _util = require("../util");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createAgentInput(specificDataStreamDir, inputTypes) {
  const agentDir = (0, _path.join)(specificDataStreamDir, 'agent', 'stream');
  const agentTemplatesDir = (0, _path.join)(__dirname, '../templates/agent');
  (0, _util.ensureDirSync)(agentDir);

  // Load common options that exists for all .yml.hbs files, to be merged with each specific input file
  const commonFilePath = (0, _path.join)(agentTemplatesDir, 'common.yml.hbs');
  const commonFile = (0, _util.readSync)(commonFilePath);
  for (const inputType of inputTypes) {
    const inputTypeFilePath = (0, _path.join)(agentTemplatesDir, `${inputType.replaceAll('-', '_')}.yml.hbs`);
    const inputTypeFile = (0, _util.readSync)(inputTypeFilePath);
    const combinedContents = `${inputTypeFile}\n${commonFile}`;
    const destinationFilePath = (0, _path.join)(agentDir, `${inputType}.yml.hbs`);
    (0, _util.createSync)(destinationFilePath, combinedContents);
  }
}