"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TelemetryEventType = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// Event type definitions
let TelemetryEventType = exports.TelemetryEventType = /*#__PURE__*/function (TelemetryEventType) {
  TelemetryEventType["UploadIntegrationZipComplete"] = "upload_integration_zip_complete";
  TelemetryEventType["IntegrationAssistantOpen"] = "integration_assistant_open";
  TelemetryEventType["IntegrationAssistantStepComplete"] = "integration_assistant_step_complete";
  TelemetryEventType["IntegrationAssistantGenerationComplete"] = "integration_assistant_generation_complete";
  TelemetryEventType["IntegrationAssistantCelGenerationComplete"] = "integration_assistant_cel_generation_complete";
  TelemetryEventType["IntegrationAssistantComplete"] = "integration_assistant_complete";
  return TelemetryEventType;
}({}); // Event data definitions
/**
 * TelemetryEventTypeData
 * Defines the relation between event types and their corresponding event data
 * */