"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TITLE = exports.STATE = exports.SAVE_BUTTON = exports.REDACT_VARS = exports.PROGRAM = exports.DESCRIPTION = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TITLE = exports.TITLE = _i18n.i18n.translate('xpack.integrationAssistant.step.reviewCel.title', {
  defaultMessage: 'Review results'
});
const DESCRIPTION = exports.DESCRIPTION = _i18n.i18n.translate('xpack.integrationAssistant.step.reviewCel.description', {
  defaultMessage: 'Review the generated CEL input configuration settings for your integration. These settings will be auto-populated into the integration configuration where editing will be possible.'
});
const PROGRAM = exports.PROGRAM = _i18n.i18n.translate('xpack.integrationAssistant.step.reviewCel.program', {
  defaultMessage: 'The CEL program to be run for each polling'
});
const STATE = exports.STATE = _i18n.i18n.translate('xpack.integrationAssistant.step.reviewCel.state', {
  defaultMessage: 'Initial CEL evaluation state'
});
const REDACT_VARS = exports.REDACT_VARS = _i18n.i18n.translate('xpack.integrationAssistant.step.reviewCel.redact', {
  defaultMessage: 'Redacted fields'
});
const SAVE_BUTTON = exports.SAVE_BUTTON = _i18n.i18n.translate('xpack.integrationAssistant.step.reviewCel.save', {
  defaultMessage: 'Save'
});