"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RETRY = exports.PROGRESS_CEL_INPUT_GRAPH = exports.GENERATION_ERROR = exports.CEL_INPUT_TITLE = exports.CEL_INPUT_DESCRIPTION = exports.API_DEFINITION_LABEL = exports.API_DEFINITION_ERROR = exports.API_DEFINITION_DESCRIPTION_2 = exports.API_DEFINITION_DESCRIPTION = exports.ANALYZING = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ANALYZING = exports.ANALYZING = _i18n.i18n.translate('xpack.integrationAssistant.step.dataStream.analyzing', {
  defaultMessage: 'Analyzing'
});
const CEL_INPUT_TITLE = exports.CEL_INPUT_TITLE = _i18n.i18n.translate('xpack.integrationAssistant.step.celInput.celInputTitle', {
  defaultMessage: 'Generate CEL input configuration'
});
const CEL_INPUT_DESCRIPTION = exports.CEL_INPUT_DESCRIPTION = _i18n.i18n.translate('xpack.integrationAssistant.step.celInput.celInputDescription', {
  defaultMessage: 'Upload an OpenAPI spec file to generate a configuration for the CEL input'
});
const API_DEFINITION_LABEL = exports.API_DEFINITION_LABEL = _i18n.i18n.translate('xpack.integrationAssistant.step.celInput.apiDefinition.label', {
  defaultMessage: 'OpenAPI spec'
});
const API_DEFINITION_DESCRIPTION = exports.API_DEFINITION_DESCRIPTION = _i18n.i18n.translate('xpack.integrationAssistant.step.celInput.apiDefinition.description', {
  defaultMessage: 'Drag and drop a file or browse files.'
});
const API_DEFINITION_DESCRIPTION_2 = exports.API_DEFINITION_DESCRIPTION_2 = _i18n.i18n.translate('xpack.integrationAssistant.step.celInput.apiDefinition.description2', {
  defaultMessage: 'OpenAPI specification'
});
const API_DEFINITION_ERROR = exports.API_DEFINITION_ERROR = {
  CAN_NOT_READ: _i18n.i18n.translate('xpack.integrationAssistant.step.celInput.openapiSpec.errorCanNotRead', {
    defaultMessage: 'Failed to read the logs sample file'
  }),
  CAN_NOT_READ_WITH_REASON: reason => _i18n.i18n.translate('xpack.integrationAssistant.step.celInput.openapiSpec.errorCanNotReadWithReason', {
    values: {
      reason
    },
    defaultMessage: 'An error occurred when reading spec file: {reason}'
  }),
  TOO_LARGE_TO_PARSE: _i18n.i18n.translate('xpack.integrationAssistant.step.celInput.openapiSpec.errorTooLargeToParse', {
    defaultMessage: 'This spec file is too large to parse'
  })
};
const PROGRESS_CEL_INPUT_GRAPH = exports.PROGRESS_CEL_INPUT_GRAPH = _i18n.i18n.translate('xpack.integrationAssistant.step.celInput.progress.relatedGraph', {
  defaultMessage: 'Generating CEL input configuration'
});
const GENERATION_ERROR = exports.GENERATION_ERROR = _i18n.i18n.translate('xpack.integrationAssistant.step.celInput.generationError', {
  defaultMessage: 'An error occurred during: CEL input generation'
});
const RETRY = exports.RETRY = _i18n.i18n.translate('xpack.integrationAssistant.step.celInput.retryButtonLabel', {
  defaultMessage: 'Retry'
});