"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Footer = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _buttons_footer = require("../../../../common/components/buttons_footer");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Generation button for Step 3
const AnalyzeButtonText = /*#__PURE__*/_react.default.memo(({
  isGenerating
}) => {
  if (!isGenerating) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, i18n.ANALYZE_LOGS);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "s",
    "data-test-subj": "generatingLoader"
  }), i18n.LOADING);
});
AnalyzeButtonText.displayName = 'AnalyzeButtonText';

// Generation button for Step 5
const AnalyzeCelButtonText = /*#__PURE__*/_react.default.memo(({
  isGenerating
}) => {
  if (!isGenerating) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, i18n.ANALYZE_CEL);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "s",
    "data-test-subj": "generatingLoader"
  }), i18n.LOADING);
});
AnalyzeCelButtonText.displayName = 'AnalyzeCelButtonText';
const Footer = exports.Footer = /*#__PURE__*/_react.default.memo(({
  isGenerating = false,
  isAnalyzeStep = false,
  isAnalyzeCelStep = false,
  isLastStep = false,
  isNextStepEnabled = false,
  isNextAddingToElastic = false,
  onBack = () => {},
  onNext = () => {}
}) => {
  const nextButtonText = (0, _react.useMemo)(() => isNextAddingToElastic ? i18n.ADD_TO_ELASTIC : isAnalyzeStep ? /*#__PURE__*/_react.default.createElement(AnalyzeButtonText, {
    isGenerating: isGenerating
  }) : isAnalyzeCelStep ? /*#__PURE__*/_react.default.createElement(AnalyzeCelButtonText, {
    isGenerating: isGenerating
  }) : null, [isNextAddingToElastic, isAnalyzeStep, isGenerating, isAnalyzeCelStep]);
  return isLastStep ? /*#__PURE__*/_react.default.createElement(_buttons_footer.ButtonsFooter, {
    cancelButtonText: i18n.CLOSE
  }) : /*#__PURE__*/_react.default.createElement(_buttons_footer.ButtonsFooter, {
    nextButtonText: nextButtonText,
    isNextDisabled: !isNextStepEnabled,
    onBack: onBack,
    onNext: onNext
  });
});
Footer.displayName = 'Footer';