"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Control = void 0;
exports.noIndexPatternMsg = noIndexPatternMsg;
exports.noValuesDisableMsg = noValuesDisableMsg;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = _interopRequireDefault(require("lodash"));
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function noValuesDisableMsg(fieldName, indexPatternName) {
  return _i18n.i18n.translate('inputControl.control.noValuesDisableTooltip', {
    defaultMessage: 'Filtering occurs on the "{fieldName}" field, which doesn\'t exist on any documents in the "{indexPatternName}" \
index pattern. Choose a different field or index documents that contain values for this field.',
    values: {
      fieldName,
      indexPatternName
    }
  });
}
function noIndexPatternMsg(indexPatternId) {
  return _i18n.i18n.translate('inputControl.control.noIndexPatternTooltip', {
    defaultMessage: 'Could not locate index-pattern id: {indexPatternId}.',
    values: {
      indexPatternId
    }
  });
}
class Control {
  constructor(controlParams, filterManager, useTimeFilter) {
    (0, _defineProperty2.default)(this, "kbnFilter", null);
    (0, _defineProperty2.default)(this, "enable", false);
    (0, _defineProperty2.default)(this, "disabledReason", '');
    (0, _defineProperty2.default)(this, "value", void 0);
    (0, _defineProperty2.default)(this, "id", void 0);
    (0, _defineProperty2.default)(this, "options", void 0);
    (0, _defineProperty2.default)(this, "type", void 0);
    (0, _defineProperty2.default)(this, "label", void 0);
    (0, _defineProperty2.default)(this, "ancestors", []);
    (0, _defineProperty2.default)(this, "format", value => {
      const indexPattern = this.filterManager.getIndexPattern();
      const field = this.filterManager.getField();
      if (field && indexPattern) {
        return indexPattern.getFormatterForField(field).convert(value);
      }
      return value;
    });
    this.controlParams = controlParams;
    this.filterManager = filterManager;
    this.useTimeFilter = useTimeFilter;
    this.id = controlParams.id;
    this.controlParams = controlParams;
    this.options = controlParams.options;
    this.type = controlParams.type;
    this.label = controlParams.label ? controlParams.label : controlParams.fieldName;

    // restore state from kibana filter context
    this.reset();
    // disable until initialized
    this.disable(_i18n.i18n.translate('inputControl.control.notInitializedTooltip', {
      defaultMessage: 'Control has not been initialized'
    }));
  }
  setAncestors(ancestors) {
    this.ancestors = ancestors;
  }
  hasAncestors() {
    return this.ancestors && this.ancestors.length > 0;
  }
  hasUnsetAncestor() {
    return this.ancestors.reduce((accumulator, ancestor) => {
      return accumulator || !ancestor.hasValue();
    }, false);
  }
  getAncestorValues() {
    return this.ancestors.map(ancestor => {
      return ancestor.value;
    });
  }
  getAncestorFilters() {
    return this.ancestors.map(ancestor => {
      return ancestor.filterManager.createFilter(ancestor.value);
    });
  }
  isEnabled() {
    return this.enable;
  }
  disable(reason) {
    this.enable = false;
    this.disabledReason = reason;
  }
  set(newValue) {
    this.value = newValue;
    if (this.hasValue()) {
      this.kbnFilter = this.filterManager.createFilter(this.value);
    } else {
      this.kbnFilter = null;
    }
  }

  /*
   * Remove any user changes to value by resetting value to that as provided by Kibana filter pills
   */
  reset() {
    this.kbnFilter = null;
    this.value = this.filterManager.getValueFromFilterBar();
  }

  /*
   * Clear any filter on the field by setting the control value to undefined.
   */
  clear() {
    this.value = undefined;
  }
  hasChanged() {
    return !_lodash.default.isEqual(this.value, this.filterManager.getValueFromFilterBar());
  }
  hasKbnFilter() {
    if (this.kbnFilter) {
      return true;
    }
    return false;
  }
  getKbnFilter() {
    return this.kbnFilter;
  }
  hasValue() {
    return this.value !== undefined;
  }
}
exports.Control = Control;