"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmptyList = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _reactRouterDom = require("react-router-dom");
var _public = require("@kbn/kibana-react-plugin/public");
var _shared_imports = require("../../../shared_imports");
var _navigation = require("../../services/navigation");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EmptyList = () => {
  const {
    services
  } = (0, _shared_imports.useKibana)();
  const history = (0, _reactRouterDom.useHistory)();
  const [showPopover, setShowPopover] = (0, _react.useState)(false);
  const createMenuItems = [{
    name: _i18n.i18n.translate('xpack.ingestPipelines.list.table.emptyPrompt.createButtonLabel', {
      defaultMessage: 'New pipeline'
    }),
    ...(0, _public.reactRouterNavigate)(history, (0, _navigation.getCreatePath)()),
    'data-test-subj': `emptyStateCreatePipelineButton`
  }, {
    name: _i18n.i18n.translate('xpack.ingestPipelines.list.table.emptyPrompt.createButtonLabel.createPipelineFromCsvButtonLabel', {
      defaultMessage: 'New pipeline from CSV'
    }),
    ...(0, _public.reactRouterNavigate)(history, (0, _navigation.getCreateFromCsvPath)()),
    'data-test-subj': `emptyStatecreatePipelineFromCsvButton`
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPageTemplate.EmptyPrompt, {
    iconType: "pipelineApp",
    iconColor: "default",
    "data-test-subj": "emptyList",
    title: /*#__PURE__*/_react.default.createElement("h2", {
      "data-test-subj": "title"
    }, _i18n.i18n.translate('xpack.ingestPipelines.list.table.emptyPromptTitle', {
      defaultMessage: 'Create your first pipeline'
    })),
    body: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.list.table.emptyPromptDescription",
      defaultMessage: "Use pipelines to remove or transform fields, extract values from text, and enrich your data before indexing."
    }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: services.documentation.getIngestNodeUrl(),
      target: "_blank",
      external: true
    }, _i18n.i18n.translate('xpack.ingestPipelines.list.table.emptyPromptDocumentionLink', {
      defaultMessage: 'Learn more'
    }))),
    actions: /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      isOpen: showPopover,
      closePopover: () => setShowPopover(false),
      button: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        fill: true,
        iconSide: "right",
        iconType: "arrowDown",
        "data-test-subj": "emptyStateCreatePipelineDropdown",
        key: "emptyStateCreatePipelineDropdown",
        onClick: () => setShowPopover(previousBool => !previousBool)
      }, _i18n.i18n.translate('xpack.ingestPipelines.list.table.emptyCreatePipelineDropdownLabel', {
        defaultMessage: 'Create pipeline'
      })),
      panelPaddingSize: "none",
      repositionOnScroll: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
      initialPanelId: 0,
      "data-test-subj": "autoFollowPatternActionContextMenu",
      panels: [{
        id: 0,
        items: createMenuItems
      }]
    }))
  });
};
exports.EmptyList = EmptyList;