"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddDatabaseModal = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
var _shared_imports = require("../../../shared_imports");
var _constants = require("./constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AddDatabaseModal = ({
  closeModal,
  reloadDatabases,
  databases
}) => {
  const [databaseType, setDatabaseType] = (0, _react.useState)(undefined);
  const [maxmind, setMaxmind] = (0, _react.useState)('');
  const [databaseName, setDatabaseName] = (0, _react.useState)('');
  const [nameExistsError, setNameExistsError] = (0, _react.useState)(false);
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const existingDatabaseNames = (0, _react.useMemo)(() => databases.map(database => database.name), [databases]);
  const {
    services
  } = (0, _shared_imports.useKibana)();
  const onDatabaseNameChange = value => {
    setDatabaseName(value);
    setNameExistsError(existingDatabaseNames.includes(value));
  };
  const isFormValid = () => {
    if (!databaseType || nameExistsError) {
      return false;
    }
    if (databaseType === 'maxmind') {
      return Boolean(maxmind) && Boolean(databaseName);
    }
    return Boolean(databaseName);
  };
  const onDatabaseTypeChange = value => {
    setDatabaseType(value);
  };
  const onAddDatabase = async event => {
    event.preventDefault();
    if (!isFormValid()) {
      return;
    }
    setIsLoading(true);
    try {
      const {
        error
      } = await services.api.createDatabase({
        databaseType: databaseType,
        databaseName,
        maxmind
      });
      setIsLoading(false);
      if (error) {
        services.notifications.toasts.addError(error, {
          title: _constants.addDatabaseErrorTitle
        });
      } else {
        services.notifications.toasts.addSuccess((0, _constants.getAddDatabaseSuccessMessage)(databaseName));
        await reloadDatabases();
        closeModal();
      }
    } catch (e) {
      setIsLoading(false);
      services.notifications.toasts.addError(e, {
        title: _constants.addDatabaseErrorTitle
      });
    }
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    css: (0, _react2.css)`
        width: 500px;
      `,
    "aria-labelledby": _constants.ADD_DATABASE_MODAL_TITLE_ID,
    onClose: closeModal,
    initialFocus: '[data-test-subj="databaseTypeSelect"]'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
    id: _constants.ADD_DATABASE_MODAL_TITLE_ID
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ingestPipelines.manageProcessors.geoip.addDatabaseModalTitle",
    defaultMessage: "Add database"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    fullWidth: true,
    id: _constants.ADD_DATABASE_MODAL_FORM_ID,
    component: "form",
    onSubmit: event => onAddDatabase(event),
    "data-test-subj": "addGeoipDatabaseForm"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.manageProcessors.geoip.addDatabaseForm.databaseTypeSelectLabel",
      defaultMessage: "Type"
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.manageProcessors.geoip.addDatabaseForm.databaseTypeSelectHelpText",
      defaultMessage: "Select the provider you want to use."
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    options: _constants.DATABASE_TYPE_OPTIONS,
    hasNoInitialSelection: true,
    value: databaseType,
    onChange: e => onDatabaseTypeChange(e.target.value),
    "data-test-subj": "databaseTypeSelect"
  })), databaseType === 'maxmind' && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.manageProcessors.geoip.licenseCalloutTitle",
      defaultMessage: "Add your MaxMind license token to the keystore"
    }),
    iconType: "info"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ingestPipelines.manageProcessors.geoip.licenseCalloutText",
    defaultMessage: "The processor needs the license key to connect to the database."
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), databaseType === 'ipinfo' && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.manageProcessors.geoip.licenseCalloutTitle",
      defaultMessage: "Add your IP Info license token to the keystore"
    }),
    iconType: "info"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ingestPipelines.manageProcessors.geoip.licenseCalloutText",
    defaultMessage: "The processor needs the license key to connect to the database."
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), databaseType === 'maxmind' && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.manageProcessors.geoip.addDatabaseForm.maxMindInputLabel",
      defaultMessage: "MaxMind Account ID"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    value: maxmind,
    onChange: e => setMaxmind(e.target.value),
    "data-test-subj": "maxmindField"
  })), databaseType && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.manageProcessors.geoip.addDatabaseForm.databaseNameSelectLabel",
      defaultMessage: "Database name"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    options: databaseType === 'maxmind' ? _constants.GEOIP_NAME_OPTIONS : _constants.IPINFO_NAME_OPTIONS,
    hasNoInitialSelection: true,
    value: databaseName,
    onChange: e => onDatabaseNameChange(e.target.value),
    "data-test-subj": "databaseNameSelect"
  }))), nameExistsError && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "danger",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.manageProcessors.geoip.nameExistsErrorTitle",
      defaultMessage: "Database already exists"
    }),
    iconType: "warning"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ingestPipelines.manageProcessors.geoip.nameExistsErrorText",
    defaultMessage: "A database needs to be added only once in order to be available."
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: closeModal
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ingestPipelines.manageProcessors.geoip.addModalCancelButtonLabel",
    defaultMessage: "Cancel"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    type: "submit",
    form: _constants.ADD_DATABASE_MODAL_FORM_ID,
    disabled: isLoading || !isFormValid(),
    "data-test-subj": "addGeoipDatabaseSubmit"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ingestPipelines.manageProcessors.geoip.addModalConfirmButtonLabel",
    defaultMessage: "Add database"
  }))));
};
exports.AddDatabaseModal = AddDatabaseModal;