"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GeoGrid = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../../../../shared_imports");
var _field_name_field = require("./common_fields/field_name_field");
var _ignore_missing_field = require("./common_fields/ignore_missing_field");
var _shared = require("./shared");
var _target_field = require("./common_fields/target_field");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fieldsConfig = {
  tile_type: {
    type: _shared_imports.FIELD_TYPES.TEXT,
    defaultValue: '',
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.geoGrid.tileTypeFieldLabel', {
      defaultMessage: 'Tile type'
    }),
    helpText: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.geoGrid.tileTypeFieldHelpText', {
      defaultMessage: 'The type of tile from field.'
    }),
    validations: [{
      validator: _shared_imports.fieldValidators.emptyField(_i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.geoGrid.tileTypeRequiredError', {
        defaultMessage: 'A tile type value is required.'
      }))
    }]
  },
  /* Optional field config */
  parent_field: {
    type: _shared_imports.FIELD_TYPES.TEXT,
    serializer: _shared.from.emptyStringToUndefined,
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.geoGrid.parentFieldLabel', {
      defaultMessage: 'Parent field (optional)'
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.pipelineEditor.geoGrid.parentFieldHelperText",
      defaultMessage: "If specified and a parent tile exists, save that tile address to this field."
    })
  },
  children_field: {
    type: _shared_imports.FIELD_TYPES.TEXT,
    serializer: _shared.from.emptyStringToUndefined,
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.geoGrid.childrenFieldLabel', {
      defaultMessage: 'Children field (optional)'
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.pipelineEditor.geoGrid.childrenFieldHelperText",
      defaultMessage: "If specified and a children tile exists, save those tile addresses to this field as an array of strings."
    })
  },
  non_children_field: {
    type: _shared_imports.FIELD_TYPES.TEXT,
    serializer: _shared.from.emptyStringToUndefined,
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.geoGrid.nonchildrenFieldLabel', {
      defaultMessage: 'Non children field (optional)'
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.pipelineEditor.geoGrid.nonchildrenFieldHelperText",
      defaultMessage: "If specified and intersecting non-child tiles exist, save their addresses to this field as an array of strings."
    })
  },
  precision_field: {
    type: _shared_imports.FIELD_TYPES.TEXT,
    serializer: _shared.from.emptyStringToUndefined,
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.geoGrid.precisionFieldLabel', {
      defaultMessage: 'Precision field (optional)'
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.pipelineEditor.geoGrid.precisionFieldHelperText",
      defaultMessage: "If specified, save the tile precision (zoom) as an integer to this field."
    })
  },
  target_format: {
    type: _shared_imports.FIELD_TYPES.TEXT,
    serializer: _shared.from.emptyStringToUndefined,
    defaultValue: '',
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.geoGrid.targetFormatFieldLabel', {
      defaultMessage: 'Target format (optional)'
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.pipelineEditor.geoGrid.targetFormatFieldHelperText",
      defaultMessage: "Which format to save the generated polygon in. Defaults to: {value}.",
      values: {
        value: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, 'Geo-JSON')
      }
    })
  }
};
const GeoGrid = () => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_field_name_field.FieldNameField, {
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.pipelineEditor.geoGrid.fieldHelpText",
      defaultMessage: "The field to interpret as a geo-tile. The field format is determined by {tile_type}.",
      values: {
        tile_type: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, 'tile_type')
      }
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_target_field.TargetField, {
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.pipelineEditor.geoGrid.targetHelpText",
      defaultMessage: "The field to assign the polygon shape to. By default {field} is updated in-place.",
      values: {
        field: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, 'field')
      }
    })
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    componentProps: {
      euiFieldProps: {
        'data-test-subj': 'tileTypeField',
        options: [{
          value: 'geohash',
          text: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.geoGrid.geohashOption', {
            defaultMessage: 'Geo-Hash'
          })
        }, {
          value: 'geotile',
          text: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.geoGrid.geotileOption', {
            defaultMessage: 'Geo-Tile'
          })
        }, {
          value: 'geohex',
          text: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.geoGrid.geohexOption', {
            defaultMessage: 'Geo-Hex'
          })
        }]
      }
    },
    config: fieldsConfig.tile_type,
    component: _shared_imports.SelectField,
    path: "fields.tile_type"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    componentProps: {
      euiFieldProps: {
        'data-test-subj': 'targetFormatField',
        options: [{
          value: 'GeoJSON',
          text: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.geoGrid.geojsonOption', {
            defaultMessage: 'GeoJSON'
          })
        }, {
          value: 'WKT',
          text: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.geoGrid.wktOption', {
            defaultMessage: 'WKT'
          })
        }]
      }
    },
    config: fieldsConfig.target_format,
    component: _shared_imports.SelectField,
    path: "fields.target_format"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    "data-test-subj": "parentField",
    config: fieldsConfig.parent_field,
    component: _shared_imports.Field,
    path: "fields.parent_field"
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    "data-test-subj": "childrenField",
    config: fieldsConfig.children_field,
    component: _shared_imports.Field,
    path: "fields.children_field"
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    "data-test-subj": "nonChildrenField",
    config: fieldsConfig.non_children_field,
    component: _shared_imports.Field,
    path: "fields.non_children_field"
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    "data-test-subj": "precisionField",
    config: fieldsConfig.precision_field,
    component: _shared_imports.Field,
    path: "fields.precision_field"
  }), /*#__PURE__*/_react.default.createElement(_ignore_missing_field.IgnoreMissingField, null));
};
exports.GeoGrid = GeoGrid;