"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fieldsConfig = exports.IgnoreMissingField = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../../../../../shared_imports");
var _shared = require("../shared");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fieldsConfig = exports.fieldsConfig = {
  ignore_missing: {
    type: _shared_imports.FIELD_TYPES.TOGGLE,
    defaultValue: false,
    deserializer: _shared.to.booleanOrUndef,
    serializer: _shared.from.undefinedIfValue(false),
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.commonFields.ignoreMissingFieldLabel', {
      defaultMessage: 'Ignore missing'
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.pipelineEditor.commonFields.ignoreMissingFieldHelpText",
      defaultMessage: "Ignore documents with a missing {field}.",
      values: {
        field: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, 'field')
      }
    })
  }
};
const IgnoreMissingField = props => /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
  config: {
    ...fieldsConfig.ignore_missing,
    ...props
  },
  component: _shared_imports.ToggleField,
  path: "fields.ignore_missing",
  "data-test-subj": "ignoreMissingSwitch"
});
exports.IgnoreMissingField = IgnoreMissingField;