"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProcessorSettingsFields = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../../../shared_imports");
var _shared = require("../shared");
var _common_fields = require("./processors/common_fields");
var _custom = require("./processors/custom");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ProcessorSettingsFields = ({
  processor
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_common_fields.ProcessorTypeField, {
    initialType: processor === null || processor === void 0 ? void 0 : processor.type
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_shared_imports.FormDataProvider, {
    pathsToWatch: "type"
  }, arg => {
    const {
      type
    } = arg;
    if (type !== null && type !== void 0 && type.length) {
      const formDescriptor = (0, _shared.getProcessorDescriptor)(type);
      if (formDescriptor) {
        const renderedFields = formDescriptor.FieldsComponent ? /*#__PURE__*/_react.default.createElement(formDescriptor.FieldsComponent, {
          key: type,
          initialFieldValues: processor === null || processor === void 0 ? void 0 : processor.options
        }) : null;
        return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, renderedFields ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, renderedFields, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null)) : renderedFields, /*#__PURE__*/_react.default.createElement(_common_fields.CommonProcessorFields, null));
      }
      return /*#__PURE__*/_react.default.createElement(_custom.Custom, {
        defaultOptions: processor === null || processor === void 0 ? void 0 : processor.options
      });
    }

    // If the user has not yet defined a type, we do not show any settings fields
    return null;
  }));
};
exports.ProcessorSettingsFields = ProcessorSettingsFields;