"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.metricsExplorerViewSavedObjectRT = exports.metricsExplorerSavedObjectTimeOptionsRT = exports.metricsExplorerSavedObjectOptionsRT = void 0;
var _ioTsUtils = require("@kbn/io-ts-utils");
var rt = _interopRequireWildcard(require("io-ts"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const metricsExplorerSavedObjectChartTypeRT = rt.keyof({
  line: null,
  area: null,
  bar: null
});
const metricsExplorerYAxisModeRT = rt.keyof({
  fromZero: null,
  auto: null
});
const metricsExplorerSavedObjectChartOptionsRT = rt.type({
  yAxisMode: metricsExplorerYAxisModeRT,
  type: metricsExplorerSavedObjectChartTypeRT,
  stack: rt.boolean
});
const metricsExplorerSavedObjectTimeOptionsRT = exports.metricsExplorerSavedObjectTimeOptionsRT = rt.type({
  from: rt.string,
  to: rt.string,
  interval: rt.string
});
const metricsExplorerSavedObjectOptionsMetricRT = rt.intersection([rt.UnknownRecord, rt.partial({
  rate: rt.boolean,
  color: rt.string,
  label: rt.string
})]);
const metricExplorerSavedObjectOptionsRequiredRT = rt.type({
  aggregation: rt.string,
  metrics: rt.array(metricsExplorerSavedObjectOptionsMetricRT)
});
const metricExplorerSavedObjectOptionsOptionalRT = rt.partial({
  limit: rt.number,
  groupBy: rt.union([rt.string, rt.array(rt.string)]),
  filterQuery: rt.string,
  source: rt.string,
  forceInterval: rt.boolean,
  dropLastBucket: rt.boolean
});
const metricsExplorerSavedObjectOptionsRT = exports.metricsExplorerSavedObjectOptionsRT = rt.intersection([metricExplorerSavedObjectOptionsRequiredRT, metricExplorerSavedObjectOptionsOptionalRT]);
const metricExplorerViewsSavedObjectStateRT = rt.type({
  chartOptions: metricsExplorerSavedObjectChartOptionsRT,
  currentTimerange: metricsExplorerSavedObjectTimeOptionsRT,
  options: metricsExplorerSavedObjectOptionsRT
});
const metricsExplorerViewSavedObjectAttributesRT = rt.intersection([metricExplorerViewsSavedObjectStateRT, rt.type({
  name: _ioTsUtils.nonEmptyStringRt
}), rt.partial({
  isDefault: rt.boolean,
  isStatic: rt.boolean
})]);
const metricsExplorerViewSavedObjectRT = exports.metricsExplorerViewSavedObjectRT = rt.intersection([rt.type({
  id: rt.string,
  attributes: metricsExplorerViewSavedObjectAttributesRT
}), rt.partial({
  version: rt.string,
  updated_at: _ioTsUtils.isoToEpochRt
})]);