"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.unflattenMetadataInfoFields = void 0;
var _lodash = require("lodash");
var _saferLodashSet = require("@kbn/safer-lodash-set");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const unflattenMetadataInfoFields = (result = {}, hit) => {
  for (const [field, value] of Object.entries((_hit$fields = hit === null || hit === void 0 ? void 0 : hit.fields) !== null && _hit$fields !== void 0 ? _hit$fields : {})) {
    var _hit$fields;
    if (value !== null && value !== undefined) {
      if ((0, _lodash.isArray)(value) && value.length > 1) {
        (0, _saferLodashSet.set)(result, field, value);
      } else {
        (0, _saferLodashSet.set)(result, field, (0, _lodash.castArray)(value)[0]);
      }
    }
  }
};
exports.unflattenMetadataInfoFields = unflattenMetadataInfoFields;