"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricsExplorerKueryBar = void 0;
var _i18n = require("@kbn/i18n");
var _esQuery = require("@kbn/es-query");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/observability-plugin/public");
var _eui = require("@elastic/eui");
var _metrics_source = require("../../../../containers/metrics_source");
var _with_kuery_autocompletion = require("../../../../containers/with_kuery_autocompletion");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function validateQuery(query) {
  try {
    (0, _esQuery.fromKueryExpression)(query);
  } catch (err) {
    return false;
  }
  return true;
}
const MetricsExplorerKueryBar = ({
  onSubmit,
  onChange,
  value,
  placeholder,
  curryLoadSuggestions = defaultCurryLoadSuggestions,
  compressed
}) => {
  const {
    metricsView
  } = (0, _metrics_source.useMetricsDataViewContext)();
  const [draftQuery, setDraftQuery] = (0, _react.useState)(value || '');
  const [isValid, setValidation] = (0, _react.useState)(true);

  // This ensures that if value changes out side this component it will update.
  (0, _react.useEffect)(() => {
    if (value) {
      setDraftQuery(value);
    }
  }, [value]);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const handleChange = query => {
    setValidation(validateQuery(query));
    setDraftQuery(query);
    if (onChange) {
      onChange(query);
    }
  };
  const defaultPlaceholder = _i18n.i18n.translate('xpack.infra.homePage.toolbar.kqlSearchFieldPlaceholder', {
    defaultMessage: 'Search for infrastructure data… (e.g. host.name:host-1)'
  });
  return /*#__PURE__*/_react.default.createElement(_with_kuery_autocompletion.WithKueryAutocompletion, {
    dataView: metricsView === null || metricsView === void 0 ? void 0 : metricsView.dataViewReference
  }, ({
    isLoadingSuggestions,
    loadSuggestions,
    suggestions
  }) => /*#__PURE__*/_react.default.createElement(_public.AutocompleteField, {
    compressed: compressed,
    "aria-label": placeholder,
    isLoadingSuggestions: isLoadingSuggestions,
    isValid: isValid,
    loadSuggestions: curryLoadSuggestions(loadSuggestions),
    onChange: handleChange,
    onSubmit: onSubmit,
    placeholder: placeholder || defaultPlaceholder,
    suggestions: suggestions,
    value: draftQuery,
    theme: euiTheme
  }));
};
exports.MetricsExplorerKueryBar = MetricsExplorerKueryBar;
const defaultCurryLoadSuggestions = loadSuggestions => (...args) => loadSuggestions(...args);