"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SeriesChart = exports.BarChart = exports.AreaChart = void 0;
var _react = _interopRequireDefault(require("react"));
var _charts = require("@elastic/charts");
var _use_kibana_time_zone_setting = require("../../../../hooks/use_kibana_time_zone_setting");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SeriesChart = props => {
  if (props.type === 'bar') {
    return /*#__PURE__*/_react.default.createElement(BarChart, props);
  }
  return /*#__PURE__*/_react.default.createElement(AreaChart, props);
};
exports.SeriesChart = SeriesChart;
const AreaChart = ({
  id,
  color,
  series,
  name,
  type,
  stack
}) => {
  const timezone = (0, _use_kibana_time_zone_setting.useKibanaTimeZoneSetting)();
  const style = {
    area: {
      opacity: 1,
      visible: 'area' === type
    },
    line: {
      strokeWidth: 'area' === type ? 1 : 2,
      visible: true
    }
  };
  return /*#__PURE__*/_react.default.createElement(_charts.AreaSeries, {
    id: id,
    name: name
    // Defaults to multi layer time axis as of Elastic Charts v70
    ,
    xScaleType: _charts.ScaleType.Time,
    yScaleType: _charts.ScaleType.Linear,
    xAccessor: "timestamp",
    yAccessors: ['value'],
    data: series.data,
    areaSeriesStyle: style,
    color: color ? color : void 0,
    stackAccessors: stack ? ['timestamp'] : void 0,
    timeZone: timezone
  });
};
exports.AreaChart = AreaChart;
const BarChart = ({
  id,
  color,
  series,
  name,
  stack
}) => {
  const timezone = (0, _use_kibana_time_zone_setting.useKibanaTimeZoneSetting)();
  const style = {
    rectBorder: {
      stroke: color || void 0,
      strokeWidth: 1,
      visible: true
    },
    rect: {
      opacity: 1
    }
  };
  return /*#__PURE__*/_react.default.createElement(_charts.BarSeries, {
    id: id,
    name: name
    // Defaults to multi layer time axis as of Elastic Charts v70
    ,
    xScaleType: _charts.ScaleType.Time,
    yScaleType: _charts.ScaleType.Linear,
    xAccessor: "timestamp",
    yAccessors: ['value'],
    data: series.data,
    barSeriesStyle: style,
    color: color ? color : void 0,
    stackAccessors: stack ? ['timestamp'] : void 0,
    timeZone: timezone
  });
};
exports.BarChart = BarChart;