"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLogsSearchUrlState = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _pipeable = require("fp-ts/lib/pipeable");
var _Either = require("fp-ts/lib/Either");
var _function = require("fp-ts/lib/function");
var _public = require("@kbn/observability-shared-plugin/public");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_QUERY = {
  language: 'kuery',
  query: ''
};
const LogsQueryStateRT = rt.type({
  language: rt.string,
  query: rt.any
});
const encodeUrlState = LogsQueryStateRT.encode;
const decodeUrlState = defaultValue => value => {
  return (0, _pipeable.pipe)(LogsQueryStateRT.decode(value), (0, _Either.fold)((0, _function.constant)(defaultValue), _function.identity));
};
const useLogsSearchUrlState = () => {
  return (0, _public.useUrlState)({
    defaultState: DEFAULT_QUERY,
    decodeUrlState: decodeUrlState(DEFAULT_QUERY),
    encodeUrlState,
    urlStateKey: 'logsQuery'
  });
};
exports.useLogsSearchUrlState = useLogsSearchUrlState;