"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useHostsTableUrlState = exports.GET_DEFAULT_TABLE_PROPERTIES = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _pipeable = require("fp-ts/lib/pipeable");
var _Either = require("fp-ts/lib/Either");
var _function = require("fp-ts/lib/function");
var _useLocalStorage = _interopRequireDefault(require("react-use/lib/useLocalStorage"));
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _react = require("react");
var _public = require("@kbn/observability-shared-plugin/public");
var _constants = require("../constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GET_DEFAULT_TABLE_PROPERTIES = exports.GET_DEFAULT_TABLE_PROPERTIES = {
  detailsItemId: null,
  sorting: {
    direction: 'desc',
    field: 'alertsCount'
  },
  pagination: {
    pageIndex: 0,
    pageSize: _constants.DEFAULT_PAGE_SIZE
  }
};
const HOST_TABLE_PROPERTIES_URL_STATE_KEY = 'tableProperties';
const reducer = (prevState, params) => {
  const payload = Object.fromEntries(Object.entries(params).filter(([_, v]) => v !== undefined));
  return {
    ...prevState,
    ...payload
  };
};
const useHostsTableUrlState = () => {
  const [localStoragePageSize, setLocalStoragePageSize] = (0, _useLocalStorage.default)(_constants.LOCAL_STORAGE_PAGE_SIZE_KEY, _constants.DEFAULT_PAGE_SIZE);
  const [urlState, setUrlState] = (0, _public.useUrlState)({
    defaultState: {
      ...GET_DEFAULT_TABLE_PROPERTIES,
      pagination: {
        ...GET_DEFAULT_TABLE_PROPERTIES.pagination,
        pageSize: localStoragePageSize
      }
    },
    decodeUrlState,
    encodeUrlState,
    urlStateKey: HOST_TABLE_PROPERTIES_URL_STATE_KEY
  });
  const [properties, setProperties] = (0, _react.useReducer)(reducer, urlState);
  if (!(0, _fastDeepEqual.default)(properties, urlState)) {
    setUrlState(properties);
    if (localStoragePageSize !== properties.pagination.pageSize) {
      setLocalStoragePageSize(properties.pagination.pageSize);
    }
  }
  return [properties, setProperties];
};
exports.useHostsTableUrlState = useHostsTableUrlState;
const PaginationRT = rt.partial({
  pageIndex: rt.number,
  pageSize: rt.number
});
const SortingRT = rt.intersection([rt.type({
  field: rt.string
}), rt.partial({
  direction: rt.union([rt.literal('asc'), rt.literal('desc')])
})]);
const TableStateRT = rt.type({
  detailsItemId: rt.union([rt.string, rt.null]),
  pagination: PaginationRT,
  sorting: SortingRT
});
const encodeUrlState = TableStateRT.encode;
const decodeUrlState = value => {
  return (0, _pipeable.pipe)(TableStateRT.decode(value), (0, _Either.fold)((0, _function.constant)(undefined), _function.identity));
};