"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogStreamPageTemplate = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _public = require("@kbn/core/public");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _public2 = require("@kbn/logs-shared-plugin/public");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _page_template = require("../../../../page_template.styles");
var _page_template2 = require("../../shared/page_template");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LogStreamPageTemplate = props => {
  const {
    logView,
    isInlineLogView,
    revertToDefaultLogView
  } = (0, _public2.useLogViewContext)();
  return /*#__PURE__*/_react.default.createElement("div", {
    className: _public.APP_WRAPPER_CLASS
  }, /*#__PURE__*/_react.default.createElement(_page_template2.LogsPageTemplate, (0, _extends2.default)({
    pageHeader: {
      pageTitle: isInlineLogView && logView ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "center",
        responsive: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, logView.attributes.name), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.infra.logStreamPageTemplate.widgetDescription",
          defaultMessage: "You are viewing an embedded widget. Changes will be synchronized to the URL, but they will not be persisted to the default Logs Stream view."
        })
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "hollow"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.infra.logStreamPageTemplate.widgetBadge",
        defaultMessage: "Widget"
      }))))) : streamTitle,
      breadcrumbs: isInlineLogView ? [{
        text: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
          gutterSize: "xs",
          alignItems: "center",
          responsive: false
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
          size: "s",
          type: "arrowLeft"
        })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.infra.logStreamPageTemplate.backtoLogsStream",
          defaultMessage: "Back to Logs Stream"
        }))),
        color: 'primary',
        'aria-current': false,
        'data-test-subj': 'infraAssetDetailsReturnButton',
        href: '#',
        onClick: revertToDefaultLogView
      }] : undefined
    },
    pageSectionProps: {
      contentProps: {
        css: _page_template.fullHeightContentStyles
      }
    }
  }, props)));
};
exports.LogStreamPageTemplate = LogStreamPageTemplate;
const streamTitle = _i18n.i18n.translate('xpack.infra.logs.streamPageTitle', {
  defaultMessage: 'Stream'
});