"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexPatternConfigurationPanel = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/observability-shared-plugin/public");
var _form_field_props = require("./form_field_props");
var _index_pattern_selector = require("./index_pattern_selector");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const IndexPatternConfigurationPanel = ({
  isLoading,
  isReadOnly,
  indexPatternFormElement
}) => {
  var _indexPatternFormElem;
  (0, _public.useTrackPageview)({
    app: 'infra_logs',
    path: 'log_source_configuration_index_pattern'
  });
  (0, _public.useTrackPageview)({
    app: 'infra_logs',
    path: 'log_source_configuration_index_pattern',
    delay: 15000
  });
  const changeIndexPatternId = (0, _react.useCallback)(dataViewId => {
    if (dataViewId != null) {
      indexPatternFormElement.updateValue(() => ({
        type: 'data_view',
        dataViewId
      }));
    } else {
      indexPatternFormElement.updateValue(() => undefined);
    }
  }, [indexPatternFormElement]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(DataViewsInlineHelpMessage, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    title: /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.logSourceConfiguration.dataViewTitle",
      defaultMessage: "Log data view"
    })),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.logSourceConfiguration.dataViewDescription",
      defaultMessage: "Data view that contains log data"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, (0, _extends2.default)({
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.infra.logSourceConfiguration.dataViewLabel",
      defaultMessage: "Log data view"
    })
  }, (0, _react.useMemo)(() => isLoading ? {} : (0, _form_field_props.getFormRowProps)(indexPatternFormElement), [isLoading, indexPatternFormElement])), /*#__PURE__*/_react.default.createElement(_index_pattern_selector.IndexPatternSelector, {
    isLoading: isLoading || indexPatternFormElement.validity.validity === 'pending',
    isReadOnly: isReadOnly,
    indexPatternId: (_indexPatternFormElem = indexPatternFormElement.value) === null || _indexPatternFormElem === void 0 ? void 0 : _indexPatternFormElem.dataViewId,
    onChangeIndexPatternId: changeIndexPatternId
  }))));
};
exports.IndexPatternConfigurationPanel = IndexPatternConfigurationPanel;
const DataViewsInlineHelpMessage = /*#__PURE__*/_react.default.memo(() => {
  const dataViewsManagementLinkProps = (0, _public.useLinkProps)({
    app: 'management',
    pathname: '/kibana/dataViews'
  });
  return /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.infra.logSourceConfiguration.logDataViewHelpText",
    defaultMessage: "Data views are shared among apps in the Kibana space and can be managed via the {dataViewsManagementLink}. A single data view can target multiple indices.",
    values: {
      dataViewsManagementLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({
        "data-test-subj": "infraDataViewsInlineHelpMessageDataViewsManagementScreenLink"
      }, dataViewsManagementLinkProps), /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.infra.logSourceConfiguration.dataViewsManagementLinkText",
        defaultMessage: "data views management screen"
      }))
    }
  });
});